<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * User indicator with acceptance interface.
 *
 * @package    block_xp
 * @copyright  2017 Frédéric Massart
 * @author     Frédéric Massart <fred@branchup.tech>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace block_xp\local\indicator;
defined('MOODLE_INTERNAL') || die();

/**
 * User indicator with acceptance interface.
 *
 * @package    block_xp
 * @copyright  2017 Frédéric Massart
 * @author     Frédéric Massart <fred@branchup.tech>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
interface user_indicator_with_acceptance extends user_indicator {

    /**
     * Specifies that we can accept a certain flag.
     *
     * @param string $flag The flag name.
     * @return void
     */
    public function set_acceptable_user_flag($flag);

    /**
     * Specifies that we can accept a certain flag.
     *
     * @param bool $value Whether we require the flag or not.
     * @return void
     */
    public function set_requires_acceptable_user_flag($value);

}
